<?php

/**
 * Fired during plugin deactivation
 *
 * @link       http://wordpress.org/plugins/blossomthemes-toolkit/
 * @since      1.0.0
 *
 * @package    Blossomthemes_Toolkit
 * @subpackage Blossomthemes_Toolkit/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Blossomthemes_Toolkit
 * @subpackage Blossomthemes_Toolkit/includes
 * @author     blossomthemes <info@blossomthemes.com>
 */
class Blossomthemes_Toolkit_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		update_option( 'bttk_queue_flush_rewrite_rules', 'yes' );
	}

}
